#include <stdio.h>
#include <stdlib.h>

typedef long long ll;

int cmp_ll(const void *a, const void *b) {
    ll x = *(const ll*)a;
    ll y = *(const ll*)b;
    if (x < y) return -1;
    if (x > y) return 1;
    return 0;
}

ll count_pairs(ll *arr, int n) {
    qsort(arr, n, sizeof(ll), cmp_ll);
    ll total = 0;
    ll cnt = 1;
    for (int i = 1; i < n; i++) {
        if (arr[i] == arr[i - 1]) {
            cnt++;
        } else {
            total += cnt * (cnt - 1) / 2;
            cnt = 1;
        }
    }
    total += cnt * (cnt - 1) / 2;
    return total;
}

int main() {
    int N;
    if (scanf("%d", &N) != 1) return 0;

    ll *d1 = (ll*)malloc(N * sizeof(ll));
    ll *d2 = (ll*)malloc(N * sizeof(ll));
    if (!d1 || !d2) return 0;

    for (int i = 0; i < N; i++) {
        ll x, y;
        scanf("%lld %lld", &x, &y);
        d1[i] = x - y;
        d2[i] = x + y;
    }

    ll ans = 0;
    ans += count_pairs(d1, N);
    ans += count_pairs(d2, N);

    printf("%lld\n", ans);

    free(d1);
    free(d2);
    return 0;
}